function V=resampling(A,vlndel)
%V=resampling(A,vlndel)
%"A" is a matrix with two columns: the first column are values of the independent variable (x, e.g. wavelengths), 
% the second column are values of the dependent variable (y, e.g. absorption coefficients). 
%"vlndel" are new values of x, where the values of y will be calculated by linear interpolation of y-values from the matrix "A". 
%"V" is the resulting matrix, in the first column are the (x) values "vlndel", 
%  in the second column are the new interpolated values of y
%Parametr "gr" (at the beginning of the function) determines whether the data will be plotted. 
%The function ignores values of "vlndel" that are autside the range of the first column of the matrix "A". 

gr=0; %If gr=1, the process will be plotted. 

%Ordering of the matrix A (from smallest to the highest values): 
[a,poradi]=sort(A(:,1));
b=A(poradi,2);
A=[a b];

%Interpolation: 
n=length(vlndel); 
minv=min(A(:,1)); maxv=max(A(:,1)); 
V=[]; 
for j=1:n, 
 if vlndel(j) >= minv & vlndel(j) <= maxv %Excludes data that would be extrapolated (not interpolated)
  [nic,por]=min(abs(vlndel(j)-A(:,1))); %Finding of the neerest wavelength 
  if vlndel(j) > A(por,1)
   epsilon=A(por,2) + (A(por+1,2)-A(por,2))*(vlndel(j)-A(por,1))/(A(por+1,1)-A(por,1));
  elseif vlndel(j) < A(por,1) 
   epsilon=A(por-1,2) + (A(por,2)-A(por-1,2))*(vlndel(j)-A(por-1,1))/(A(por,1)-A(por-1,1));
  else
   epsilon=A(por,2);
  end
  V=[V; vlndel(j) epsilon];
 end
end

%Graph: 
if gr==1
 figure; plot(V(:,1),V(:,2),'r.',A(:,1),A(:,2),'b'); title('Re-sampling'); 
end
